# 仙人掌
像其他植物一样，[仙人掌](objects/cactus)可以种植在耕过的土地上并照常收获。

然而，仙人掌大小不一，并有一种奇怪的秩序感。

如果收获一株完全成熟的仙人掌，并且所有相邻的仙人掌都已排序，则所有相邻的仙人掌也会以递归方式收获。

如果所有 `North` 和 `East` 方向的相邻仙人掌都完全成熟且尺寸大于或等于它，并且所有 `South` 和 `West` 方向的相邻仙人掌都完全成熟且尺寸小于或等于它，那么这个仙人掌就被认为是处于已排序状态

只有当所有相邻的仙人掌都完全成熟并处于已排序状态时，收获才会蔓延。
也就是说，如果一个方形区域的成熟仙人掌已经按大小排序，那么收获其中一株仙人掌时，会随之收获整个方形区域。

一株完全成熟的仙人掌如果未排序，会显示为棕色。一旦排序好，则会变回绿色。

你将获得的仙人掌数量等于所收获仙人掌数量的平方。因此，如果同时收获 `n` 个仙人掌，则将获得 `n**2` 个 `Items.Cactus`。

仙人掌的大小可以用 `measure()` 测量。
测量结果始终为以下数字之一：`0,1,2,3,4,5,6,7,8,9`。

你也可以向 `measure(direction)` 传入一个方向来测量无人机该方向上的相邻地块。

使用 `swap()` 命令可将一株仙人掌与其任何方向的邻居交换位置。
`swap(direction)` 将无人机下方的物体与无人机 `direction` 方向一格远的物体交换位置。

## 示例
在这些网格中，所有的仙人掌都处于已排序状态，收获将蔓延到整片田地：
`3 4 5    3 3 3    1 2 3    1 5 9
2 3 4    2 2 2    1 2 3    1 3 8
1 2 3    1 1 1    1 2 3    1 3 4`

在该网格中，只有左下角的仙人掌处于已排序状态，这不足以让收获蔓延：
`1 5 3
4 9 7
3 3 2`

<spoiler=显示提示 1>
如果行已经排序，对列进行排序不会打乱行的顺序。
</spoiler>
<spoiler=显示提示 2>
如果不熟悉排序算法，不妨在网上查一下，思考可以参照哪些算法来解决这个问题。请记住，并非所有算法都有效，因为你只能交换相邻的仙人掌。
</spoiler>